USE [ProSolutionReports]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE VIEW [vOG_2526_StaffTeachingGroup]
AS

SELECT DISTINCT
O.AcademicYearID,
S.StaffRefNo AS StaffCode,
/* choose one or other of the next two lines depending on whether Offering Groups are used*/
O.Code + ' - ' + ISNULL(OG.Code, '') AS TeachingGroupCode -- with offering groups, or
--O.Code AS TeachingGroupCode, -- no offering groups

FROM
	ProSolution.dbo.RegisterLecturer RL WITH (NOLOCK)
		INNER JOIN ProSolution.dbo.RegisterCourse RC WITH (NOLOCK) 
		ON RL.RegisterID = RC.RegisterID
			INNER JOIN ProSolution.dbo.Offering O WITH (NOLOCK)	
			ON RC.OfferingID = O.OfferingID
				INNER JOIN ProSolution.dbo.Staff S WITH (NOLOCK) 
				ON RL.StaffID = S.StaffID
					LEFT JOIN ProSolution.dbo.OfferingGroup AS OG WITH (NOLOCK)
					ON O.OfferingID = OG.OfferingID 
WHERE
	O.AcademicYearID = '25/26'
	AND S.IsCurrent=1
	AND EXISTS (SELECT DISTINCT TeachingGroupCode FROM vOG_2526_Enrolment WHERE TeachingGroupCode = O.Code + ' - ' + ISNULL(OG.Code, '')) -- remove OG.Code if Offering Groups not used
GO
